<?php

/**
 * Plugin Name:       Ultimate AI
 * Plugin URI:        https://ultimateai.io/
 * Description:       Unlock the power of cutting-edge technology with Ultimate AI, the ultimate Content, Text, Image, Video, Chat, Voice, and Code Generator as a SaaS platform. Designed to revolutionize the way you create      and communicate, Ultimate AI offers a comprehensive suite of tools that go beyond traditional features and benefits.
 * Version:           2.8.0
 * Requires at least: 5.0
 * Requires PHP:      7.2
 * Author:            20script
 * Author URI:        https://www.20script.ir
 * License:           Envato Licence 2.0
 * Text Domain:       ultimate_ai
 * Domain Path:       /languages.
 */
class Ultimate_AI_Base
{
  public const ULTIMATE_AI_APP_URL = 'admin.php?page=ultimate_ai_app';

  public function __construct()
  {
    $this->constant();
    $this->include_files();
    add_action('admin_menu', [$this, 'ultimate_ai_add_setting_page']);
    add_action('wp_enqueue_scripts', [$this, 'ultimate_ai_enqueue_frontend_script']);
    add_action('admin_enqueue_scripts', [$this, 'ultimate_ai_enqueue_admin_script']);
    add_filter('body_class', [$this, 'add_body_class']);
    add_action('admin_menu', [$this, 'dashboard_app_link']);
    // activation with redirect
    register_activation_hook(__FILE__, [$this, 'redirect_on_activation']);
    add_action('admin_init', [$this, 'redirect_after_activation']);
  }

  public function constant()
  {
    define('ULTIMATE_AI_PLUGIN_ROOT', plugin_dir_path(__FILE__)); // use plugin_dir_path(important)
    define('ULTIMATE_AI_SLUG', 'ultimate_ai');
    define('UAI_ASSETS_URL_JS', plugins_url('assets/js/', __FILE__));
    define('UAI_ASSETS_URL_CSS', plugins_url('assets/css/', __FILE__));
    define('UAI_ASSETS_URL_IMG', plugins_url('assets/images/', __FILE__));
    define('UAI_ASSETS_URL', plugins_url('assets', __FILE__));
    if (!function_exists('get_plugin_data')) {
      require_once ABSPATH . 'wp-admin/includes/plugin.php';
    }
    $plugin_data = get_plugin_data(__FILE__);

    define('UAI_VERSION', $plugin_data['Version']);
  }

  public function include_files()
  {
    // model class files
    include 'model/Theme_Setting_Manager.php';
    include 'model/openAI/Open_AI_Arg_Settings.php'; // this class need to load first. OpenAI_Api_Manager extend this class
    include 'model/openAI/OpenAI_Api_Manager.php';
    include 'model/user/User_Manager.php';
    include 'model/templates/default_template.php';
    include 'model/templates/Ultimate_AI_templates.php';
    include 'model/chat_assistant/Ultimate_AI_chat_assistant.php';
    include 'model/faq/Ultimate_AI_Faq.php';
    include 'model/plugin_activation_task_manager.php';
    include 'model/History_Manager.php';
    // include "model/User_Settings_Model.php"; need to remove
    include 'model/payments/Ultimate_AI_Payments_Module.php';
    include 'model/Ultimate_AI_Categories.php';
    include 'model/Ultimate_AI_Activity.php';
    include 'model/payments/stripe/init.php';
    include 'model/payments/Ultimate_AI_Stripe.php';
    include 'model/payments/Ultimate_AI_Paypal.php';
    include 'model/payments/Ultimate_AI_WooCommerce.php';
    include 'model/subscription/Ultimate_AI_Subscription.php';
    include 'model/Orders.php';
    include 'model/Ultimate_AI_License.php';
    include 'model/SD/stable_diffusion.php';
    include 'model/Ultimate_AI_TTS.php';
    include 'model/translation.php';

    // ajax api controller
    include 'controller/license_controller.php';
    include 'controller/payment.php';
    include 'controller/subscription.php';
    include 'controller/openAI/open_ai_api.php';
    include 'controller/article-controller.php';
    include 'controller/history_api.php';
    include 'controller/user_api.php';
    include 'controller/dashboard.php';
    include 'controller/templates_api.php';
    include 'controller/chat_assistant_api.php';
    include 'controller/faq_api.php';
    include 'controller/categories.php';
    include 'controller/theme_settings_api.php';
    include 'controller/utils/upload_image.php';
    include 'controller/utils/utils.php';
    include 'controller/menu_api.php';
    include 'controller/integration_api.php';
    include 'controller/text_to_speech.php';
    include 'controller/onboarding.php';
    include 'controller/style.php';

    // elementor files
    include 'elementor/elementor_init.php';
  }

  public function add_body_class($classes)
  {
    $dashboard_page_id = get_option('ultimate_ai_dashboard_page_id');
    if (is_page($dashboard_page_id)) {
      return array_merge($classes, ['ultimate-ai-dashboard']);
    }

    return $classes;
  }

  public function ultimate_ai_add_setting_page()
  {
    // add_menu_page(
    //   esc_html__('Dashboard', ULTIMATE_AI_SLUG),
    //   esc_html__('Dashboard', ULTIMATE_AI_SLUG),
    //   'edit_theme_options',
    //   'ultimate_ai',
    //   [$this, 'render_root_page'],
    //   // BACKEND_MEDIA_URL . 'logo.png',
    //   // 10
    // );
  }

  public function render_root_page()
  {
    echo "<div id='ultimate-ai-root'></div>";
  }

  public static function ultimate_ai_get_local_variable()
  {
    $dashboard_page_id = get_option('ultimate_ai_dashboard_page_id');

    $theme_settings_manager = new Ultimate_AI_Theme_Setting_Manager();
    $translation = new Ultimate_ai_Translation_Manager();
    $settings = $theme_settings_manager->ultimate_ai_get_theme_settings(['uai_social_login_settings', 'uai_theme_appearance_settings', 'uai_app_settings', 'uai_general_settings']);

    $template_manager = new Ultimate_AI_Template_Manager();
    $templates = $template_manager->ultimate_ai_get_templates(['meta_query' => [['key' => 'is_active', 'value' => false, 'compare' => '!=']]]);
    if (!empty($templates['templates'])) {
      $templates = $templates['templates'];
    } else {
      $templates = [];
    }

    $SUBSCRIPTION = new Ultimate_AI_Subscription();

    return [
      'IMAGES_URL' => UAI_ASSETS_URL_IMG,
      'ASSETS_URL' => UAI_ASSETS_URL,
      'BACKEND_AJAX_URL' => admin_url('admin-ajax.php'),
      'SITE_ROOT' => get_site_url(),
      'DEFAULT_CURRENCY_SYMBOL' => $SUBSCRIPTION->getCurrencySymbol($SUBSCRIPTION->getDefaultCurrency()),
      'WEEK_END_DATE' => date('Y-m-d', strtotime('sunday this week')),
      'SITE_TITLE' => get_bloginfo('name'),
      'PLUGIN_VERSION' => UAI_VERSION,
      'USER_MENU_ITEMS' => get_option('ultimate_ai_menu_data', []),
      'TEMPLATES' => $templates,
      'GOOGLE_CLIENT_ID' => $settings['uai_social_login_settings']['google_client_id'] ?? '',
      'THEME_APPEARANCE_SETTINGS' => $settings['uai_theme_appearance_settings'] ?? [],
      'APP_SETTINGS' => $settings['uai_app_settings'] ?? [],
      'GENERAL_SETTINGS' => $settings['uai_general_settings'] ?? [],
      'DASHBOARD_PAGE_PERMALINK' => get_the_permalink($dashboard_page_id),
      'LOGOUT_URL' => wp_logout_url(get_the_permalink($dashboard_page_id)),
      'CURRENT_USER_ROLES' => is_user_logged_in() ? array_values(wp_get_current_user()->roles) : [],
      'TRANSLATION' => $translation->get_default_language(),
      'WOOCOMMERCE' => [
        'WOO_ACTIVE' => class_exists('WooCommerce') ? true : false,
        'YITH_SUBSCRIPTION_ACTIVE' => class_exists('YITH_WC_Subscription') ? true : false,
        'WOO_INSTALL' => admin_url('plugin-install.php?s=woocommerce&tab=search&type=term'),
        'YITH_INSTALL' => admin_url('plugin-install.php?s=yith-subscription&tab=search&type=term')
      ]
    ];
  }

  public function ultimate_ai_enqueue_script_wrapper($handle, $file_name)
  {
    wp_enqueue_script($handle, UAI_ASSETS_URL_JS . $file_name, ['wp-i18n', 'jquery'], UAI_VERSION, true);
    wp_localize_script($handle, 'UAI_LOCAL', $this->ultimate_ai_get_local_variable());
  }

  public function ultimate_ai_enqueue_frontend_script()
  {
    // ENQUEUE JS,CSS FILE IF ITS DASHBOARD PAGE
    $dashboard_page_id = get_option('ultimate_ai_dashboard_page_id');
    if (is_page($dashboard_page_id)) {
      // js
      $this->ultimate_ai_enqueue_script_wrapper('ultimate_ai_dashboard_page_script', 'dashboard.bundle.js');
    }

    // style
    wp_enqueue_style('ultimate_ai_style', UAI_ASSETS_URL_CSS . 'style.css', [], UAI_VERSION);
    // loads on every front page
    $this->ultimate_ai_enqueue_script_wrapper('ultimate_ai_global_script', 'global.js');
    wp_enqueue_style('ultimate_ai_backend_style', UAI_ASSETS_URL_CSS . 'global.css');
  }

  public function ultimate_ai_enqueue_admin_script()
  {
    if (isset($_GET['page']) && $_GET['page'] === 'ultimate_ai_app') {
      $this->ultimate_ai_enqueue_script_wrapper('ultimate_ai_admin_page_script', 'uai_admin.bundle.js');
      wp_enqueue_style('ultimate_ai_style', UAI_ASSETS_URL_CSS . 'style.css', [], UAI_VERSION);
    }
  }

  public function dashboard_app_link()
  {
    add_menu_page(
      esc_html__('UltimateAI', ULTIMATE_AI_SLUG),
      esc_html__('UltimateAI', ULTIMATE_AI_SLUG),
      'edit_theme_options',
      'ultimate_ai_app',
      [$this, 'render_root_page'],
      'dashicons-art',
      10
    );
  }

  // Redirect on activation
  public function redirect_on_activation()
  {
    add_option('ultimate_ai_do_activation_redirect', true);
  }

  public function redirect_after_activation()
  {
    if (get_option('ultimate_ai_do_activation_redirect', false)) {
      delete_option('ultimate_ai_do_activation_redirect');
      wp_safe_redirect(admin_url(self::ULTIMATE_AI_APP_URL));
      exit;
    }
  }
}

new Ultimate_AI_Base();
